<?php
include("../includes/config.php");
include("../includes/db_connect.php");
include("../includes/functions.php");

require_once('../vendor/autoload.php');

$result = array();

if(isset($_POST["quiz_id"])) {
	
	$quiz_id = $_POST["quiz_id"];
	
	if(TEST_MODE) {
		$result["status"] = 0;
		$result["error"] = "DEMO MODE : You can't delete a quiz.";
	} else {
	
		if($_SESSION) {
			
			$user_id = $_SESSION["USER_ID"];
			
			// Check if the news exists
			$quiz_query = $dbh->prepare("SELECT id FROM quiz WHERE unique_id = :quiz_id AND user_id = :user_id");
			$quiz_query->bindParam(":user_id", $user_id);
			$quiz_query->bindParam(":quiz_id", $quiz_id);
			$quiz_query->execute();
			
			$nb_res_quizz = $quiz_query->rowCount();	
			
			if($nb_res_quizz == 1) {
				
				$quiz = $quiz_query->fetch();
				$quiz_id = $quiz["id"];
				
				$quiz_query = $dbh->prepare("DELETE FROM quiz WHERE id = :quiz_id");
				$quiz_query->bindParam(":quiz_id", $quiz_id);
				$quiz_query->execute();
				
				$quiz_query = $dbh->prepare("DELETE FROM question WHERE quiz_id = :quiz_id");
				$quiz_query->bindParam(":quiz_id", $quiz_id);
				$quiz_query->execute();
				
				$quiz_query = $dbh->prepare("DELETE FROM question_answers WHERE quiz_id = :quiz_id");
				$quiz_query->bindParam(":quiz_id", $quiz_id);
				$quiz_query->execute();
				
				$result["status"] = 1;
				
			} else {
				
				$result["status"] = 0;
				$result["error"] = "This quiz doesn't exist anymore...";
				
			}
			
		} else {
			
			$result["status"] = 0;
			$result["error"] = "Your session has expired. Please log-in again to continue...";
			
		}
	
	}
	
}

echo json_encode($result);
?>